import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import {
  GetPropertyParams,
  GetPropertyResponse,
  GetPropertiesFeaturedParams,
  GetPropertiesFeaturedResponse,
  GetPropertiesSuperFeaturedParams,
  GetPropertiesSuperFeaturedResponse,
  GetPropertiesParams,
  GetPropertiesResponse,
  GetPropertTypesResponse,
  GetPropertTypesParams,
  GetPropertCategoriesResponse,
  GetPropertCategoriesParams,
  GetPropertUrbTypesResponse,
  GetPropertUrbTypesParams,
  CreatePropertyResponse,
  CreatePropertyParams,
  GenerateWithAiResponse,
  GenerateWithAiParams,
  AddKeyResponse,
  AddKeyParams,
  EasyBrokersResponse,
  EasyBrokersParams,
  UpdateKeyResponse,
  UpdateKeyParams,
  DeleteKeyResponse,
  DeleteKeyParams,
  EasyBrokersPropertiesResponse,
  EasyBrokersPropertiesParams,
  GetPropertyFromEasyBrokerResponse,
  GetPropertyFromEasyBrokerParams,
  UpdatePropertyFromEasyBrokerResponse,
  UpdatePropertyFromEasyBrokerParams,
  CreatePropertyFromEasyBrokerResponse,
  CreatePropertyFromEasyBrokerParams,
  ImportPropertyResponse,
  ImportPropertyParams,
  getPropertyCompleteResponse,
  getPropertyCompleteParams,
  EasyBrokersPropertiesAllTagsResponse,
  HandleExcelsResponse,
  HandleExcelsParams,
  getSeoIndexResponse,
  getSeoIndexParams,
} from "./propertiesActions.d";

type initialStateProps = {
  getPropertySuperFeatured: {
    loadingPropertiesSuperFeatured: boolean;
    propertiesSuperFeatured: GetPropertiesSuperFeaturedResponse["properties"];
    successSuperFeaturedProperties: boolean;
    errorSuperFeaturedProperties: string | null;
  };
  getPropertyFeatured: {
    loadingPropertiesFeatured: boolean;
    propertiesFeatured: GetPropertiesFeaturedResponse["properties"];
    successFeaturedProperties: boolean;
    errorFeaturedProperties: string | null;
  };
  getProperties: {
    loadingProperties: boolean;
    properties: GetPropertiesResponse["properties"];
    totalProperties: GetPropertiesResponse["total"] | undefined;
    successProperties: boolean;
    errorProperties: string | null;
  };
};

const initialState: initialStateProps = {
  getPropertySuperFeatured: {
    loadingPropertiesSuperFeatured: false,
    propertiesSuperFeatured: [],
    successSuperFeaturedProperties: false,
    errorSuperFeaturedProperties: null,
  },
  getPropertyFeatured: {
    loadingPropertiesFeatured: false,
    propertiesFeatured: [],
    successFeaturedProperties: false,
    errorFeaturedProperties: null,
  },
  getProperties: {
    loadingProperties: false,
    properties: [],
    totalProperties: 0,
    successProperties: false,
    errorProperties: null,
  },
};

export const getProperty = createAsyncThunk<
  GetPropertyResponse,
  GetPropertyParams
>("property/getProperty", async (params, { rejectWithValue }) => {
  try {
    const query = await params.context.getProperty(params);

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: GetPropertyResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

export const getPropertySuperFeatured = createAsyncThunk<
  GetPropertiesSuperFeaturedResponse,
  GetPropertiesSuperFeaturedParams
>("property/getPropertySuperFeatured", async (params, { rejectWithValue }) => {
  try {
    const query = await params.context.getPropertySuperFeatured(params);

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: GetPropertiesSuperFeaturedResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

export const getPropertyFeatured = createAsyncThunk<
  GetPropertiesFeaturedResponse,
  GetPropertiesFeaturedParams
>("property/getPropertyFeatured", async (params, { rejectWithValue }) => {
  try {
    const query = await params.context.getPropertyFeatured(params);

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: GetPropertiesFeaturedResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

export const getProperties = createAsyncThunk<
  GetPropertiesResponse,
  GetPropertiesParams
>("property/getProperties", async (params, { rejectWithValue }) => {
  try {
    const query = await params.context.getProperties(params);

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: GetPropertiesResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

export const getPropertiesSearch = createAsyncThunk<
  GetPropertiesResponse,
  GetPropertiesParams
>("property/getPropertiesSearch", async (params, { rejectWithValue }) => {
  try {
    const query = await params.context.getPropertiesSearch(params);

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: GetPropertiesResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

export const getPropertiesUser = createAsyncThunk<
  GetPropertiesResponse,
  GetPropertiesParams
>("property/getPropertiesUser", async (params, { rejectWithValue }) => {
  try {
    const query = await params.context.getPropertiesUser(params);

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: GetPropertiesResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

export const GetPropertyTypes = createAsyncThunk<
  GetPropertTypesResponse,
  GetPropertTypesParams
>("property/getProperties", async (params, { rejectWithValue }) => {
  try {
    const query = await params.context.getPropertyTypes();

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: GetPropertTypesResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});
export const GetPropertyCategories = createAsyncThunk<
  GetPropertCategoriesResponse,
  GetPropertCategoriesParams
>("property/getProperties", async (params, { rejectWithValue }) => {
  try {
    const query = await params.context.getPropertyCategories();

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: GetPropertCategoriesResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

export const createProperty = createAsyncThunk<
  CreatePropertyResponse,
  CreatePropertyParams
>("property/createProperty", async (params, { rejectWithValue }) => {
  try {
    const query = await params.context.createProperty(params);

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: CreatePropertyResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

export const GetPropertyUrbTypes = createAsyncThunk<
  GetPropertUrbTypesResponse,
  GetPropertUrbTypesParams
>("property/getProperties", async (params, { rejectWithValue }) => {
  try {
    const query = await params.context.getPropertyUrbTypes();

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: GetPropertUrbTypesResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});
export const generateWithAi = createAsyncThunk<
  GenerateWithAiResponse,
  GenerateWithAiParams
>("property/generateWithAi", async (params, { rejectWithValue }) => {
  try {
    const { context, ...paramsrest } = params;
    const query = await context.generateWithAi({
      ...paramsrest,
    });

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: GenerateWithAiResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

export const easybrokersIndex = createAsyncThunk<
  EasyBrokersResponse,
  EasyBrokersParams
>("property/easybrokersIndex", async (params, { rejectWithValue }) => {
  try {
    const { context, ...paramsrest } = params;
    const query = await context.easybrokersIndex({
      ...paramsrest,
    });

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: EasyBrokersResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

export const easybrokersIndexProperties = createAsyncThunk<
  EasyBrokersPropertiesResponse,
  EasyBrokersPropertiesParams
>(
  "property/easybrokersIndexProperties",
  async (params, { rejectWithValue }) => {
    try {
      const { context, ...paramsrest } = params;
      const query = await context.easybrokersIndexProperties({
        ...paramsrest,
      });
      const query2 = await context.easybrokersIndexPropertiesAllTags({
        ...paramsrest,
      });

      if (query.error) {
        throw new Error(query.message);
      }

      if (query.data.data.error) {
        throw new Error(query.data.data.message);
      }

      if (query2.error) {
        throw new Error(query2.message);
      }

      if (query2.data.data.error) {
        throw new Error(query2.data.data.message);
      }

      const response: EasyBrokersPropertiesResponse = query.data.data.data;
      const response2: EasyBrokersPropertiesAllTagsResponse =
        query2.data.data.data;

      return {
        ...response,
        allIds: response2.array ?? [],
      } as EasyBrokersPropertiesResponse;
    } catch (error) {
      return rejectWithValue(error);
    }
  }
);

export const addKey = createAsyncThunk<AddKeyResponse, AddKeyParams>(
  "property/addKey",
  async (params, { rejectWithValue }) => {
    try {
      const { context, ...paramsrest } = params;
      const query = await context.addKey({
        ...paramsrest,
      });

      if (query.error) {
        throw new Error(query.message);
      }

      if (query.data.data.error) {
        throw new Error(query.data.data.message);
      }

      const response: AddKeyResponse = query.data.data.data;

      return response;
    } catch (error) {
      return rejectWithValue(error);
    }
  }
);
export const updateKey = createAsyncThunk<UpdateKeyResponse, UpdateKeyParams>(
  "property/updateKey",
  async (params, { rejectWithValue }) => {
    try {
      const { context, ...paramsrest } = params;
      const query = await context.updateKey({
        ...paramsrest,
      });

      if (query.error) {
        throw new Error(query.message);
      }

      if (query.data.data.error) {
        throw new Error(query.data.data.message);
      }

      const response: UpdateKeyResponse = query.data.data.data;

      return response;
    } catch (error) {
      return rejectWithValue(error);
    }
  }
);
export const deleteKey = createAsyncThunk<DeleteKeyResponse, DeleteKeyParams>(
  "property/deleteKey",
  async (params, { rejectWithValue }) => {
    try {
      const { context, ...paramsrest } = params;
      const query = await context.deleteKey({
        ...paramsrest,
      });

      if (query.error) {
        throw new Error(query.message);
      }

      if (query.data.data.error) {
        throw new Error(query.data.data.message);
      }

      const response: DeleteKeyResponse = query.data.data.data;

      return response;
    } catch (error) {
      return rejectWithValue(error);
    }
  }
);
export const getPropertyFromEasyBroker = createAsyncThunk<
  GetPropertyFromEasyBrokerResponse,
  GetPropertyFromEasyBrokerParams
>("property/getPropertyFromEasyBroker", async (params, { rejectWithValue }) => {
  try {
    const { context, ...paramsrest } = params;
    const query = await context.getPropertyFromEasyBroker({
      ...paramsrest,
    });

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: GetPropertyFromEasyBrokerResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

export const createPropertyFromEasyBroker = createAsyncThunk<
  CreatePropertyFromEasyBrokerResponse,
  CreatePropertyFromEasyBrokerParams
>("property/getPropertyFromEasyBroker", async (params, { rejectWithValue }) => {
  try {
    const { context, ...paramsrest } = params;
    const query = await context.createPropertyFromEasyBroker({
      ...paramsrest,
    });

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: CreatePropertyFromEasyBrokerResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});
export const updatePropertyFromEasyBroker = createAsyncThunk<
  UpdatePropertyFromEasyBrokerResponse,
  UpdatePropertyFromEasyBrokerParams
>("property/getPropertyFromEasyBroker", async (params, { rejectWithValue }) => {
  try {
    const { context, ...paramsrest } = params;
    const query = await context.updatePropertyFromEasyBroker({
      ...paramsrest,
    });

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: UpdatePropertyFromEasyBrokerResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

export const importProperty = createAsyncThunk<
  ImportPropertyResponse,
  ImportPropertyParams
>("property/importProperty", async (params, { rejectWithValue }) => {
  try {
    const { context, ...paramsrest } = params;
    const query = await context.importProperty({
      ...paramsrest,
    });

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: ImportPropertyResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

export const handleExcels = createAsyncThunk<
  HandleExcelsResponse,
  HandleExcelsParams
>("property/handleExcels", async (params, { rejectWithValue }) => {
  try {
    const { context, ...paramsrest } = params;
    const query = await context.handleExcels({
      ...paramsrest,
    });

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: HandleExcelsResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

export const getPropertyComplete = createAsyncThunk<
  getPropertyCompleteResponse,
  getPropertyCompleteParams
>("property/getPropertyComplete", async (params, { rejectWithValue }) => {
  try {
    const { context, ...paramsrest } = params;
    const query = await context.getPropertyComplete({
      ...paramsrest,
    });

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: getPropertyCompleteResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

export const getSeoIndex = createAsyncThunk<
  getSeoIndexResponse,
  getSeoIndexParams
>("property/getSeoIndex", async (params, { rejectWithValue }) => {
  try {
    const { context, ...paramsrest } = params;
    const query = await context.getSeoIndex({
      ...paramsrest,
    });

    if (query.error) {
      throw new Error(query.message);
    }

    if (query.data.data.error) {
      throw new Error(query.data.data.message);
    }

    const response: getSeoIndexResponse = query.data.data.data;

    return response;
  } catch (error) {
    return rejectWithValue(error);
  }
});

const propertieslice = createSlice({
  name: "property",
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder.addCase(getPropertySuperFeatured.pending, (state) => {
      state.getPropertySuperFeatured.loadingPropertiesSuperFeatured = true;
    });
    builder.addCase(getPropertySuperFeatured.fulfilled, (state, action) => {
      state.getPropertySuperFeatured.loadingPropertiesSuperFeatured = false;
      state.getPropertySuperFeatured.successSuperFeaturedProperties = true;
      state.getPropertySuperFeatured.propertiesSuperFeatured =
        action.payload.properties;
    });
    builder.addCase(getPropertySuperFeatured.rejected, (state, action) => {
      state.getPropertySuperFeatured.loadingPropertiesSuperFeatured = false;
      state.getPropertySuperFeatured.errorSuperFeaturedProperties =
        action.payload as string;
    });
    builder.addCase(getPropertyFeatured.pending, (state) => {
      state.getPropertyFeatured.loadingPropertiesFeatured = true;
    });
    builder.addCase(getPropertyFeatured.fulfilled, (state, action) => {
      state.getPropertyFeatured.loadingPropertiesFeatured = false;
      state.getPropertyFeatured.successFeaturedProperties = true;
      state.getPropertyFeatured.propertiesFeatured = action.payload.properties;
    });
    builder.addCase(getPropertyFeatured.rejected, (state, action) => {
      state.getPropertyFeatured.loadingPropertiesFeatured = false;
      state.getPropertyFeatured.errorFeaturedProperties =
        action.payload as string;
    });
    builder.addCase(getProperties.pending, (state) => {
      state.getProperties.loadingProperties = true;
    });
    builder.addCase(getProperties.fulfilled, (state, action) => {
      state.getProperties.loadingProperties = false;
      state.getProperties.successProperties = true;
      state.getProperties.properties = action.payload.properties;
      state.getProperties.totalProperties = action.payload.total;
    });
    builder.addCase(getProperties.rejected, (state, action) => {
      state.getProperties.loadingProperties = false;
      state.getProperties.errorProperties = action.payload as string;
    });
  },
});

export const {} = propertieslice.actions;

export default propertieslice.reducer;
