/* eslint-disable @typescript-eslint/no-explicit-any */
import { AlertTypes } from "@/hooks/useRnSwal/useRnSwal.d";
import { createSlice } from "@reduxjs/toolkit";

interface InitialStateProps {
  modal: {
    type: AlertTypes;
    modalType: string;
    title: string;
    text: string;
    text2: string;
    text3: string;
    okFunction: () => any;
    cancel: () => any;
    open: boolean;
  };
}

const initialState: InitialStateProps = {
  modal: {
    type: "success",
    modalType: "",
    title: "",
    text: "",
    text2: "",
    text3: "",
    okFunction: () => {},
    cancel: () => {},
    open: false,
  },
};

const swalSlice = createSlice({
  name: "swal",
  initialState,
  reducers: {
    showTooltipAction: (state, action) => {
      state.modal.modalType = "tooltip";
      state.modal.title = action?.payload?.title ?? "defaultTitle";
      state.modal.text = action?.payload?.text ?? "defaultText";
      state.modal.open = true;
    },
    showAlertAction: (state, action) => {
      state.modal.type = action.payload.type;
      state.modal.modalType = "tooltip";
      state.modal.title = action?.payload?.title ?? "defaultTitle";
      state.modal.text = action?.payload?.text1;
      state.modal.text2 = action?.payload?.text2;
      state.modal.text3 = action?.payload?.text3;
      state.modal.open = true;
      state.modal.okFunction = action.payload.okFunction;
      state.modal.cancel = action.payload.cancel;
    },
    clearSwal: (state) => {
      state.modal = initialState.modal;
    },
  },
});

export const { showTooltipAction, showAlertAction, clearSwal } =
  swalSlice.actions;

export default swalSlice.reducer;
