/* eslint-disable @typescript-eslint/no-empty-object-type */
import { ReduxToolkitThunkWithContext } from "@/types/main/types";
import { PhotosAndBookProps } from "../../../../components/FormInput/types";
import { UserInterface } from "@/types/users/types";

export interface loginWithEmailResponse {
  access_token: string;
  users: UserInterface;
}
export interface loginWithEmailParams extends ReduxToolkitThunkWithContext {
  email: string;
  password: string;
}

export interface RegisterUserResponse {
  user: UserInterface;
  roles: string[];
  permissions: string[];
  access_token: string;
}
export interface RegisterUserParams extends ReduxToolkitThunkWithContext {
  name: string;
  lastName: string;
  email: string;
  password: string;
  confirmPassword: string;
  termsAndConditions: 0 | 1;
}

export interface UpdateUserResponse {
  user: UserInterface;
  roles: string[];
  permissions: string[];
  access_token: string;
}
export interface UpdateUserParams extends ReduxToolkitThunkWithContext {
  name: string;
  lastName: string;
  phone: string;
  officePhone: string;
  sex: string;
  profileCompany: string;
  showModalPassword: 0 | 1;
  password: string;
  confirmPassword: string;
  companyName: string;
  country: string;
  state: string;
  city: string;
  companyLat: number;
  companyLng: number;
  companyLocation: string;
  twitter: string;
  youtube: string;
  linkedin: string;
  tiktok: string;
  instagram: string;
  facebookpage: string;
}

export interface verifyLoginCodeParams extends ReduxToolkitThunkWithContext {
  code: number;
  lada: number;
  phone: number;
}

export interface verifyLoginCodeResponse extends ReduxToolkitThunkWithContext {
  person: UserInterface;
  access_token: string;
}

export interface sendAccessCodeResponse extends ReduxToolkitThunkWithContext {
  codes: null;
}
export interface sendAccessCodeParams extends ReduxToolkitThunkWithContext {
  lada: number;
  phone: number;
}

export interface recoveryTokenResponse {
  user: UserInterface;
  access_token: string;
}
export interface recoveryTokenParams extends ReduxToolkitThunkWithContext {}
export interface saveDeviceTokenResponse {
  person: UserInterface | null;
  access_token: string | null;
}
export interface saveDeviceTokenParams extends ReduxToolkitThunkWithContext {
  token: string;
}

export interface forgotPasswordParams extends ReduxToolkitThunkWithContext {
  email: string;
}

export interface UploadImagesResponse {
  persons: null;
}
export interface UploadImagesParams extends ReduxToolkitThunkWithContext {
  data: string;
  file_middle: string;
  file_complete: string;
}

export interface RegisterFlowUploadDNIResponse {
  persons: null;
}
export interface RegisterFlowUploadDNIParams
  extends ReduxToolkitThunkWithContext {
  data?: string;
  file_one: string;
  file_two: string;
  is_optional: "0" | "1";
  type: "INE" | "PASSPORT" | "INM" | "OTHER";
}

export interface sendRegistrationCodeResponse {
  codes: null;
}
export interface sendRegistrationCodeParams
  extends ReduxToolkitThunkWithContext {
  email: string;
  lada: string;
  phone: string;
}

export interface verifyRegistrationCodeResponse {
  email: string;
}
export interface verifyRegistrationCodeParams
  extends ReduxToolkitThunkWithContext {
  code: string;
}

export interface GetCastingResponse {
  castings: string[];
  country_id: number;
}
export interface GetCastingParams extends ReduxToolkitThunkWithContext {
  casting: string;
}

export interface RegisterFlowAlbumStepOneResponse {
  albums: string | { id: string };
}
export interface RegisterFlowAlbumStepOneParams
  extends ReduxToolkitThunkWithContext {
  data?: string;
  fromProfile?: boolean;
  book_type_id: string;
  book_category_id: string;
  description: string;
}

export interface RegisterFlowAlbumStepTwoResponse {
  albums: null;
}
export interface RegisterFlowAlbumStepTwoParams
  extends ReduxToolkitThunkWithContext {
  data: string;
  cv: string;
  url: string;
  type: "YOUTUBE" | "VIMEO";
  album_id?: string;
}

export interface RegisterFlowAlbumStepThreeResponse {
  albums: null;
}
export interface RegisterFlowAlbumStepThreeParams
  extends ReduxToolkitThunkWithContext {
  data?: string;
  album_id?: string;
  file: string;
}

export interface GetBooksResponse {
  albums: {
    album_name: string;
    alias: string;
    id: number;
    photos_count: number;
    profile: {
      id: number;
      photo_name: string;
      album_id: number;
    } | null;
  }[];
}
export interface GetBooksParams extends ReduxToolkitThunkWithContext {
  data: string;
}

export interface GetBooksResponse {
  albums: PhotosAndBookProps[];
}
export interface GetBooksParams extends ReduxToolkitThunkWithContext {
  data: string;
}

export interface GetBookPhotosResponse {
  photos: { id: string; name: string }[];
}
export interface GetBookPhotosParams extends ReduxToolkitThunkWithContext {
  data: string;
  id?: number;
}

export interface DeleteBooksResponse {
  photos: null;
}
export interface DeleteBooksParams extends ReduxToolkitThunkWithContext {
  hash: string;
  from_profile?: boolean;
}
export interface SelectPhotoAsPrimaryResponse {
  photo: null;
}
export interface SelectPhotoAsPrimaryParams
  extends ReduxToolkitThunkWithContext {
  hash: string;
}

export interface UpdateMyDataResponse {
  persons: UserInterface[];
  is_reload: boolean;
}
export interface UpdateMyDataParams extends ReduxToolkitThunkWithContext {
  name: string;
  birthday: string;
  gender: "MEN" | "WOMAN" | "OTHER";
  nationality_id: number;
  country_id: number;
  state_id: number;
  city_id: number;
  colony_id: number;
  is_family: 0 | 1;
  is_password: 0 | 1;
  height: number;
  shirt: string | number;
  trouser: number;
  shoe: number;
  with_tattoos: "NO" | "NOT_VISIBLE" | "VISIBLE";
  phone_code: number;
  phone: number;
  cellphone_code: number;
  cellphone: number;
  email: string;
  password: string;
  password_confirmation: string;
  file_covid: string;
}

export interface UpdateMyBankDataResponse {
  persons: UserInterface[];
}
export interface UpdateMyBankDataParams extends ReduxToolkitThunkWithContext {
  name: string;
  holder: string;
  account: number;
  clabe: number;
  email: string;
  phone: number;
  curp: string;
  rfc: string;
  social_number: string;
  file_32d: string;
}

export interface GetOccupationsResponse {
  positions: {
    name: string;
    hash: string;
  }[];
}
export interface GetOccupationsParams extends ReduxToolkitThunkWithContext {}

export interface GetSpecialistCaravansResponse {
  users: {
    id: number;
    name: string;
    last_name: string;
    caravan: string;
    hash: string;
    branches: {
      id: number;
      hash: string;
      name: string;
    }[];
  }[];
}
export interface GetSpecialistCaravansParams
  extends ReduxToolkitThunkWithContext {
  stateId?: number;
  locationId?: string;
}

export interface UpdateUserResponse {
  users: null;
}
export interface UpdateUserParams extends ReduxToolkitThunkWithContext {
  name: string;
  lastName: string;
  phone: string;
  officePhone: string;
  sex: "M" | "H" | "I";
  profileCompany: string;
  showModalPassword: 0 | 1;
  password: string;
  confirmPassword: string;
  companyName: string;
  country: string;
  state: string;
  city: string;
  companyLat: number;
  companyLng: number;
  companyLocation: string;
  twitter: string;
  youtube: string;
  linkedin: string;
  tiktok: string;
  instagram: string;
  facebookpage: string;
}

export interface CaravanDefaultSelectionResponse {
  users: null;
}
export interface CaravanDefaultSelectionParams
  extends ReduxToolkitThunkWithContext {
  zone_id: string;
  start_date: string; // yyyy-MM-dd
  end_date: string; // yyyy-MM-dd
  user_id: string;
}

export interface GetProfileResponse {
  users: {
    nombre: string;
    apellido: string;
    direccionFisica: string;
    facebookpage: string;
    instagram: string;
    nombreInmobiliaria: string | null;
    telefonoOficina: string;
    telefonoPersonal: string;
    perfilEmpresarial: string;
    lat: number;
    lng: number;
    linkedin: string;
    twitter: string;
    youtube: string;
    img: string;
    tiktok: string;
    id: string;
    totalProperties: number;
    totalFollowme: number;
  };
}
export interface GetProfileParams extends ReduxToolkitThunkWithContext {
  id: string;
}
