/* eslint-disable @typescript-eslint/no-explicit-any */
type PERSONAL_INFO = "PersonalInfo";

type StepNames = PERSONAL_INFO;

const storeSpaceLabel: string = "contractPolicyStoredData";

const PersonalInfo = "PersonalInfo";

const STEPS: StepNames[] = [PersonalInfo];

const STEPS_ARRAY: string[] = [];

type StepData = Record<string, any>;

export const addCompleteStep = async (
  step: StepNames,
  stepContent: Record<string, any>
): Promise<string | void> => {
  if (!STEPS.includes(step)) {
    return;
  }

  const lastContentInStorage = await localStorage.getItem(storeSpaceLabel);
  const lastContent: StepData = lastContentInStorage
    ? JSON.parse(lastContentInStorage)
    : {};

  const payload: StepData = {
    ...lastContent,
    [step]: {
      ...stepContent,
    },
  };

  const payloadConverted = JSON.stringify(payload);

  await localStorage.setItem(storeSpaceLabel, payloadConverted);

  return "success";
};

export const updatePropertyInStepData = async (
  step: StepNames,
  prop: string,
  value: any
): Promise<string | void> => {
  if (!STEPS.includes(step)) {
    return;
  }

  const lastContentInStorage = await localStorage.getItem(storeSpaceLabel);
  const lastContent: StepData = lastContentInStorage
    ? JSON.parse(lastContentInStorage)
    : {};

  const payload: StepData = {
    ...lastContent,
    [step]: {
      ...(lastContent?.[step] ?? {}),
      [prop]: value,
    },
  };

  const payloadConverted = JSON.stringify(payload);

  await localStorage.setItem(storeSpaceLabel, payloadConverted);

  return "success";
};

export const updateStepInLocalStorage = async (
  currentStep: number
): Promise<void> => {
  const lastContentInStorage = await localStorage.getItem(storeSpaceLabel);
  const lastContent: StepData = lastContentInStorage
    ? JSON.parse(lastContentInStorage)
    : {};

  const payload: StepData = {
    ...lastContent,
    step: currentStep,
  };

  const payloadConverted = JSON.stringify(payload);

  await localStorage.setItem(storeSpaceLabel, payloadConverted);
};

export const updateVisitTimeInLocalStorage = async (
  visitTime: number
): Promise<void> => {
  const lastContentInStorage = await localStorage.getItem(storeSpaceLabel);
  const lastContent: StepData = lastContentInStorage
    ? JSON.parse(lastContentInStorage)
    : {};

  const payload: StepData = {
    ...lastContent,
    visitingTime: visitTime,
  };

  const payloadConverted = JSON.stringify(payload);

  await localStorage.setItem(storeSpaceLabel, payloadConverted);
};

export const updateTemporalStep = async (
  currentStep: string
): Promise<void> => {
  const lastContentInStorage = await localStorage.getItem(storeSpaceLabel);
  const lastContent: StepData = lastContentInStorage
    ? JSON.parse(lastContentInStorage)
    : {};

  const payload: StepData = {
    ...lastContent,
    temporalStep: currentStep,
  };

  const payloadConverted = JSON.stringify(payload);

  await localStorage.setItem(storeSpaceLabel, payloadConverted);
};

export const updateFormsInArray = async (
  currentStep: string,
  index: number,
  prop: string,
  value: any
): Promise<string | void> => {
  if (!STEPS_ARRAY.includes(currentStep)) {
    return;
  }

  const lastContentInStorage = await localStorage.getItem(storeSpaceLabel);
  const lastContent: StepData = lastContentInStorage
    ? JSON.parse(lastContentInStorage)
    : {};

  const lastArrayOfForms = [...(lastContent[currentStep] ?? [])];

  lastArrayOfForms.splice(index, 1, {
    ...(lastContent?.[currentStep]?.[index] ?? {}),
    [prop]: value,
  });

  const payload: StepData = {
    ...lastContent,
    [currentStep]: lastArrayOfForms,
  };

  const payloadConverted = JSON.stringify(payload);

  await localStorage.setItem(storeSpaceLabel, payloadConverted);

  return "success";
};

export const clearFormInArray = async (
  currentStep: string,
  index: number
): Promise<string | void> => {
  if (!STEPS_ARRAY.includes(currentStep)) {
    return;
  }

  const lastContentInStorage = await localStorage.getItem(storeSpaceLabel);
  const lastContent: StepData = lastContentInStorage
    ? JSON.parse(lastContentInStorage)
    : {};

  const lastArrayOfForms = [...(lastContent[currentStep] ?? [])];

  lastArrayOfForms.splice(index, 1, {});

  const payload: StepData = {
    ...lastContent,
    [currentStep]: lastArrayOfForms,
  };

  const payloadConverted = JSON.stringify(payload);

  await localStorage.setItem(storeSpaceLabel, payloadConverted);

  return "success";
};

export const getStoredData = async (step: StepNames): Promise<any> => {
  if (!STEPS.includes(step)) {
    return;
  }

  const lastContentInStorage = await localStorage.getItem(storeSpaceLabel);
  const lastContent: StepData = lastContentInStorage
    ? JSON.parse(lastContentInStorage)
    : {};

  return lastContent?.[step] ?? {};
};

export const getCurrentStep = async (): Promise<number> => {
  const lastContentInStorage = await localStorage.getItem(storeSpaceLabel);
  const lastContent: StepData = lastContentInStorage
    ? JSON.parse(lastContentInStorage)
    : {};

  return lastContent?.step ?? 0;
};

export const getCurrentVisitingTime = async (): Promise<number> => {
  const lastContentInStorage = await localStorage.getItem(storeSpaceLabel);
  const lastContent: StepData = lastContentInStorage
    ? JSON.parse(lastContentInStorage)
    : {};

  return lastContent?.visitingTime ?? 0;
};

export const getTemporalStep = async (): Promise<string | number> => {
  const lastContentInStorage = await localStorage.getItem(storeSpaceLabel);
  const lastContent: StepData = lastContentInStorage
    ? JSON.parse(lastContentInStorage)
    : {};

  return lastContent?.temporalStep ?? 0;
};

export const clearAllData = async (): Promise<{ success: boolean }> => {
  await localStorage.removeItem(storeSpaceLabel);

  return {
    success: true,
  };
};

export const removeFromArray = async (
  currentStep: string,
  index: number
): Promise<string | void> => {
  if (!STEPS_ARRAY.includes(currentStep)) {
    return;
  }

  const lastContentInStorage = await localStorage.getItem(storeSpaceLabel);
  const lastContent: StepData = lastContentInStorage
    ? JSON.parse(lastContentInStorage)
    : {};

  const lastArrayOfForms = [...(lastContent[currentStep] ?? [])];

  lastArrayOfForms.splice(index, 1);

  const payload: StepData = {
    ...lastContent,
    [currentStep]: lastArrayOfForms,
  };

  const payloadConverted = JSON.stringify(payload);

  await localStorage.setItem(storeSpaceLabel, payloadConverted);

  return "success";
};
