export async function getFileFromLocalPath(path: string): Promise<Blob | null> {
  try {
    const response = await fetch(`file://${path}`);
    if (!response.ok) {
      throw new Error(`No se pudo leer el archivo: ${response.statusText}`);
    }
    return await response.blob();
  } catch (error) {
    console.error('Error obteniendo Blob:', error);
    return null;
  }
}
