import {formatDistance} from 'date-fns';
import {enUS, es, Locale} from 'date-fns/locale';

export type SupportedLocales = 'en' | 'es';

const localesMap: Record<SupportedLocales, Locale> = {
  en: enUS,
  es: es,
};

export const getTimeAgo = (
  timestamp: string | number | Date,
  locale: SupportedLocales = 'en',
): string => {
  const date = new Date(timestamp);

  const currentLocale = localesMap[locale] || enUS;

  return formatDistance(date, new Date(), {
    addSuffix: true,
    locale: currentLocale,
  });
};
