/**
 * Calculate the total number of pages.
 * @param {number} totalRecords - The total number of records in the database.
 * @param {number} limitPerPage - The limit of records per page.
 * @returns {number} - The total number of pages.
 */
export function calculateTotalPages(
  totalRecords: number,
  limitPerPage: number
) {
  if (limitPerPage <= 0) {
    throw new Error("Limit per page must be greater than zero.");
  }
  return Math.ceil(totalRecords / limitPerPage);
}
