/* eslint-disable @typescript-eslint/no-explicit-any */
export function toQueryString(params: Record<string, any>): string {
  const query = Object.entries(params)
    .map(([key, value]) => {
      if (Array.isArray(value)) {
        // Si es un array, une sus valores con coma
        return `${encodeURIComponent(key)}=${encodeURIComponent(
          value.join(",")
        )}`;
      } else if (value !== undefined && value !== null) {
        // Si es un valor simple, conviértelo directamente
        return `${encodeURIComponent(key)}=${encodeURIComponent(value)}`;
      } else {
        // Si es null o undefined, omítelo (opcional)
        return "";
      }
    })
    .filter(Boolean) // Elimina los pares vacíos
    .join("&");

  return query ? `?${query}` : "";
}
