import { NextRequest, NextResponse } from "next/server";
import createMiddleware from "next-intl/middleware";
import { parse } from "cookie";
import { AllRoutes, RoutesConfig } from "@/lib/routes";

const intlMiddleware = createMiddleware({
  locales: ["en", "es"],
  defaultLocale: "es",
  localePrefix: "always",
});
const privatePaths: string[] = RoutesConfig.filter(
  (route) => route.private
).map((route) => route.path);

function isPrivateRoute(pathname: string): boolean {
  return privatePaths.some(
    (privatePath) =>
      pathname === privatePath || pathname.startsWith(`${privatePath}/`)
  );
}

export default function middleware(req: NextRequest): NextResponse {
  const res = intlMiddleware(req);
  const { pathname: realpathname } = req.nextUrl;

  const pathname = realpathname.replace("/es", "").replace("/en", "");

  if (isPrivateRoute(pathname)) {
    const cookieHeader = req.headers.get("cookie") || "";
    const cookies = parse(cookieHeader);
    const token = cookies.access_token;

    if (!token) {
      const loginUrl = req.nextUrl.clone();
      loginUrl.pathname = AllRoutes.MAIN;
      return NextResponse.redirect(loginUrl);
    }
  }

  return res;
}

export const config = {
  matcher: ["/((?!_next|.*\\..*).*)"],
  runtime: 'nodejs',
};
