import React from "react";
import styles from "./styles.module.scss";
import { useTranslations } from "next-intl";
import { createPropertyFormData } from "../../components/CreatePropertyForm/types";
import {
  CreatePropertyParams,
  CreatePropertyResponse,
} from "@/lib/services/redux/reducers/properties/propertiesActions.d";
import { createProperty } from "@/lib/services/redux/reducers/properties/propertiesActions";
import useRequestHandler from "@/hooks/useRequestHandler/useRequestHandler";
import { AllRoutes } from "@/lib/routes";
import { useRouter } from "next/navigation";
import SwalComponent from "@/components/SwalComponent/SwalComponent";
import useRnSwal from "@/hooks/useRnSwal/useRnSwal";
import CreatePropertyForm from "@/components/CreatePropertyForm/CreatePropertyForm";

const CreateProperty = () => {
  const t = useTranslations();

  const navigate = useRouter();

  const {
    fetcher: createPropertyFetch,
    requestStatus: createPropertyRequestStatus,
  } = useRequestHandler<CreatePropertyResponse, CreatePropertyParams>(
    createProperty
  );

  const { clearAll, showAlert } = useRnSwal();

  const handleSubmit = async (values: createPropertyFormData) => {
    const propertyFiles = values?.propertyFiles.map((d, index) => {
      return {
        url: d.uri,
        type: d.type,
        order: index,
        isDeleted: 0,
      };
    });

    const payload: Omit<CreatePropertyParams, "context"> = {
      title: values?.title ?? "",
      price: values?.price ?? 0,
      description: values?.description ?? "",
      categoryId: values?.operationType ?? "",
      isVideo: values?.addVideo ?? 0,
      alias: values?.identifier ?? "",
      antiquity: values?.age?.toString() ?? "",
      lat:
        values?.location?.lat ??
        Number(process.env.NEXT_PUBLIC_CDMX_LAT) ??
        19.4326,
      lng:
        values?.location?.lng ??
        Number(process.env.NEXT_PUBLIC_CDMX_LNG) ??
        -99.1332,
      typeId: values?.propertyType ?? "",
      isAa: values?.aa ? 1 : 0,
      isWater: values?.hasWater ? 1 : 0,
      isFurnished: values?.furnished ? 1 : 0,
      baths: values?.fullBathrooms ?? 0,
      isBeds: values?.beds ? 1 : 0,
      isCloset: values?.closet ? 1 : 0,
      isKitchen: values?.kitchen ? 1 : 0,
      isDiningRoom: values?.diningroom ? 1 : 0,
      isDisabled: values?.accessibleForDisabled ? 1 : 0,
      isSchool: values?.nearbySchools ? 1 : 0,
      isStove: values?.stove ? 1 : 0,
      isGas: values?.hasGas ? 1 : 0,
      rooms: values?.bedrooms ?? 0,
      isOven: values?.oven ? 1 : 0,
      isWifi: values?.hasInternet ? 1 : 0,
      isWashingMachine: values?.washingmachine ? 1 : 0,
      isLight: values?.hasElectricity ? 1 : 0,
      m2Build: values?.builtArea ?? 0,
      m2Property: values?.landArea ?? 0,
      isMaintenance: values?.maintenanceIncluded ? 1 : 0,
      halfbaths: values?.halfBathrooms ?? 0,
      isMicrowave: values?.microwave ? 1 : 0,
      isMiniOven: values?.oven ? 1 : 0,
      parking: values?.parkingSpots ?? 0,
      isSwimmingPool: values?.hasPool ? 1 : 0,
      level: values?.floors ? 1 : 0,
      isRefrigerator: values?.refrigerator ? 1 : 0,
      isLivingRoom: values?.livingroom ? 1 : 0,
      isDryingMachine: values?.driyingmachine ? 1 : 0,
      isVideoSurveillance: values?.hasSecurityCameras ? 1 : 0,
      isPrivateSecurity: values?.privateSecurity ? 1 : 0,
      countryId: values?.country ?? "",
      stateId: values?.state ?? "",
      cityId: values?.city ?? "",
      others: values?.others ?? "",
      setId: values?.complex ?? "",
      images: propertyFiles.filter((d) => d.type !== "video/mp4") ?? [],
      videos: propertyFiles.filter((d) => d.type === "video/mp4") ?? [],
    };

    const query = await createPropertyFetch(payload);

    if (query.status === "success") {
      showAlert(
        "success",
        t("propertyCreatedSuccessfully"),
        undefined,
        undefined,
        undefined,
        () => {
          clearAll();
          navigate.push(AllRoutes?.PROFILE);
        }
      );
    }
  };

  return (
    <div className={styles.container}>
      <div className={styles.maxContainer} style={{ marginBottom: 100 }}>
        <p className={styles.pageTitle}>{t("addProperty")}</p>
        <div className={styles.divider}></div>
        <CreatePropertyForm
          handleSubmit={handleSubmit}
          loading={createPropertyRequestStatus?.loading}
        />
      </div>
      <SwalComponent />
    </div>
  );
};

export default CreateProperty;
