/* eslint-disable react-hooks/exhaustive-deps */
import React, { useCallback, useEffect, useRef, useState } from "react";
import styles from "./styles.module.scss";
import { useTranslations } from "next-intl";
import {
  Button,
  Fade,
  IconButton,
  InputBase,
  Popper,
  Radio,
} from "@mui/material";
import { Tune } from "@mui/icons-material";
import useStyles from "./sxStyles";
import { PRIMARY_COLOR, WHITE } from "@/styles/constants";
import {
  GetPropertCategoriesParams,
  GetPropertCategoriesResponse,
  GetPropertTypesParams,
  GetPropertTypesResponse,
  GetPropertUrbTypesParams,
  GetPropertUrbTypesResponse,
} from "@/lib/services/redux/reducers/properties/propertiesActions.d";
import {
  GetPropertyCategories,
  GetPropertyTypes,
  GetPropertyUrbTypes,
} from "@/lib/services/redux/reducers/properties/propertiesActions";
import useRequestHandler from "@/hooks/useRequestHandler/useRequestHandler";
import { SelectOptionsProps } from "@/components/FormInput/types";
import { useRouter } from "next/navigation";
import { AllRoutes } from "@/lib/routes";
import { toQueryString } from "@/lib/utils/toQueryString";
import { SearchObject } from "@/screens/Results/components/MoreFilters/moreFilters";
import markericon from "@/assets/icons/marker.svg";
import Image from "next/image";

const SearchComponent = () => {
  const t = useTranslations();

  const navigation = useRouter();

  const containerRef = useRef<HTMLDivElement>(null);
  const mainContainerRef = useRef<HTMLDivElement>(null);

  const [filters, setFilters] = useState<SearchObject>({});

  const [anchorEl, setAnchorEl] = useState<HTMLElement | null>(null);
  const classes = useStyles();
  const open = Boolean(anchorEl);

  const { fetcher: fetcherTypes } = useRequestHandler<
    GetPropertTypesResponse,
    GetPropertTypesParams
  >(GetPropertyTypes);
  const { fetcher: fetcherUrbTypes } = useRequestHandler<
    GetPropertUrbTypesResponse,
    GetPropertUrbTypesParams
  >(GetPropertyUrbTypes);
  const { fetcher: fetcherCategories } = useRequestHandler<
    GetPropertCategoriesResponse,
    GetPropertCategoriesParams
  >(GetPropertyCategories);

  const [propertyTypes, setPropertyTypes] = useState<SelectOptionsProps[]>([]);
  const [categories, setCategories] = useState<SelectOptionsProps[]>([]);
  const [urbTypes, setUrbTypes] = useState<SelectOptionsProps[]>([]);

  const quantities = Array(6)
    .fill(0)
    .map((d, i) => {
      return {
        label: `${d + i + 1}+`,
        name: `${d + i + 1}+`,
        value: d + i + 1,
      };
    });

  const retryFunction = async () => {
    const typeshere = await fetcherTypes({});

    if (typeshere.status === "success") {
      setPropertyTypes(
        typeshere.response.types.map((d) => {
          return {
            label: d.nombre,
            name: d.id,
            value: d.id,
          };
        })
      );
    }

    const urbTypeshere = await fetcherUrbTypes({});

    if (urbTypeshere.status === "success") {
      setUrbTypes(
        urbTypeshere.response.sets.map((d) => {
          return {
            label: d.nombre,
            name: d.id,
            value: d.id,
          };
        })
      );
    }
    const categorieshere = await fetcherCategories({});

    if (categorieshere.status === "success") {
      setCategories(
        categorieshere.response.categories.map((d) => {
          return {
            label: d.nombre,
            name: d.id,
            value: d.id,
          };
        })
      );
    }
  };

  useEffect(() => {
    retryFunction();
  }, []);

  const handlePropertyTypes = useCallback(
    (val: string) => {
      const values = [...(filters.propertyType ?? [])];

      if (values.includes(val)) {
        setFilters({
          ...filters,
          propertyType: values.filter((d) => d !== val),
        });
      } else {
        setFilters({ ...filters, propertyType: values.concat(val) });
      }
    },
    [filters]
  );
  const handlePropertyUrbTypes = useCallback(
    (val: string) => {
      const values = [...(filters.urbType ?? [])];

      if (values.includes(val)) {
        setFilters({
          ...filters,
          urbType: values.filter((d) => d !== val),
        });
      } else {
        setFilters({ ...filters, urbType: values.concat(val) });
      }
    },
    [filters]
  );

  const handleClean = () => {
    setFilters({
      price: [0, 0],
      terrain: [0, 0],
      built: [0, 0],
    });
  };

  const handleSubmit = useCallback(() => {
    const stringParams = toQueryString(filters);

    navigation.push(AllRoutes.RESULTS_VIEW + stringParams);
  }, [filters, navigation]);

  return (
    <>
      <div className={styles.container} ref={mainContainerRef}>
        <p className={styles.text1}>{t("homeText1")}</p>
        <div className={styles.text2}>
          <span>{t("homeText2")}</span>
          <span style={{ color: PRIMARY_COLOR }}>{t("homeText21")}</span>
        </div>
        <div className={styles.searchContainer}>
          <div className={styles.radios} ref={containerRef}>
            {categories.map((d) => {
              return (
                <div
                  key={d.name}
                  onClick={() => setFilters({ ...filters, category: d.value })}
                  className={styles.radioonly}
                >
                  <Radio
                    checked={filters.category === d.value}
                    value="outlined"
                  />
                  <p>{t(d.label)}</p>
                </div>
              );
            })}
          </div>
          <div className={styles.divisor}></div>
          <div className={styles.input}>
            <Image
              style={{ width: "25px", height: "25px" }}
              src={markericon}
              alt="markericon"
            />
            <InputBase
              className={styles.inputBase}
              placeholder={t("enterCodeOrAddress")}
              value={filters?.search ?? ""}
              onKeyDown={(event) => {
                if (event.key === "Enter") {
                  handleSubmit();
                }
              }}
              onChange={(d) => {
                setFilters({ ...filters, search: d.target.value });
              }}
            />
          </div>
          <div className={styles.buttonsFilters}>
            <IconButton
              onClick={() =>
                setAnchorEl(anchorEl ? null : mainContainerRef.current)
              }
              className={styles.buttonfilters}
            >
              <Tune />
            </IconButton>

            <Button
              variant="contained"
              color="primary"
              disableElevation
              className={styles.buttonfiltersresp}
              onClick={() =>
                setAnchorEl(anchorEl ? null : mainContainerRef.current)
              }
              startIcon={<Tune />}
            >
              {t("filters")}
            </Button>
            <Button
              variant="contained"
              color="primary"
              disableElevation
              className={styles.search}
              onClick={handleSubmit}
            >
              {t("search")}
            </Button>
          </div>
        </div>
      </div>
      <Popper
        open={open}
        anchorEl={anchorEl}
        placement={"bottom"}
        className={classes.popper}
        transition
      >
        {({ TransitionProps }) => (
          <Fade {...TransitionProps} timeout={350}>
            <div className={classes.container}>
              <div className={styles.card}>
                <p className={styles.title}>{t("propertyType")}</p>
                {propertyTypes.map((d) => {
                  return (
                    <Button
                      variant="contained"
                      disableElevation
                      key={d.value}
                      className={styles.button}
                      style={{
                        minWidth: "22.5%",
                        background: filters.propertyType?.includes(d.value)
                          ? PRIMARY_COLOR
                          : WHITE,
                        color: !filters.propertyType?.includes(d.value)
                          ? PRIMARY_COLOR
                          : WHITE,
                      }}
                      onClick={() => handlePropertyTypes(d.value)}
                    >
                      {d.label}
                    </Button>
                  );
                })}
              </div>
              <div className={styles.rowOfCards}>
                <div className={styles.cardLimit}>
                  <div className={styles.card}>
                    <p className={styles.title}>{t("rooms")}</p>
                    {quantities.map((d) => {
                      return (
                        <Button
                          variant="contained"
                          key={d.name}
                          disableElevation
                          className={styles.buttonrowOfCards}
                          style={{
                            minWidth: "22.5%",
                            background:
                              filters.rooms === d.value ? PRIMARY_COLOR : WHITE,
                            color:
                              filters.rooms !== d.value ? PRIMARY_COLOR : WHITE,
                          }}
                          onClick={() =>
                            setFilters({ ...filters, rooms: d.value })
                          }
                        >
                          {d.label}
                        </Button>
                      );
                    })}
                  </div>
                </div>
                <div className={styles.cardLimit}>
                  <div className={styles.card}>
                    <p className={styles.title}>{t("bathRooms")}</p>
                    {quantities.map((d) => {
                      return (
                        <Button
                          variant="contained"
                          key={d.name}
                          disableElevation
                          className={styles.buttonrowOfCards}
                          style={{
                            minWidth: "22.5%",
                            background:
                              filters.bathRooms === d.value
                                ? PRIMARY_COLOR
                                : WHITE,
                            color:
                              filters.bathRooms !== d.value
                                ? PRIMARY_COLOR
                                : WHITE,
                          }}
                          onClick={() =>
                            setFilters({ ...filters, bathRooms: d.value })
                          }
                        >
                          {d.label}
                        </Button>
                      );
                    })}
                  </div>
                </div>
                <div className={styles.cardLimit}>
                  <div className={styles.card}>
                    <p className={styles.title}>{t("parkings")}</p>
                    {quantities.map((d) => {
                      return (
                        <Button
                          variant="contained"
                          key={d.name}
                          disableElevation
                          className={styles.buttonrowOfCards}
                          style={{
                            minWidth: "22.5%",
                            background:
                              filters.parkings === d.value
                                ? PRIMARY_COLOR
                                : WHITE,
                            color:
                              filters.parkings !== d.value
                                ? PRIMARY_COLOR
                                : WHITE,
                          }}
                          onClick={() =>
                            setFilters({ ...filters, parkings: d.value })
                          }
                        >
                          {d.label}
                        </Button>
                      );
                    })}
                  </div>
                </div>
              </div>
              <div className={styles.rowOfCards}>
                <div className={styles.cardLimit}>
                  <div
                    className={styles.card}
                    style={{ height: "fit-content" }}
                  >
                    <p className={styles.title}>{t("price")}</p>
                    <div className={styles.inputRow}>
                      <InputBase
                        className={styles.input}
                        placeholder={t("from")}
                        type="number"
                        value={filters?.price?.[0] ?? undefined}
                        onChange={(d) => {
                          const value = [...(filters.price ?? [])];
                          value[0] = Number(d.target.value);

                          setFilters({ ...filters, price: value });
                        }}
                      />
                      <InputBase
                        className={styles.input}
                        placeholder={t("until")}
                        type="number"
                        value={filters?.price?.[1] ?? undefined}
                        onChange={(d) => {
                          const value = [...(filters.price ?? [])];
                          value[1] = Number(d.target.value);

                          setFilters({ ...filters, price: value });
                        }}
                      />
                    </div>
                  </div>
                </div>
                <div className={styles.cardLimit}>
                  <div
                    className={styles.card}
                    style={{ height: "fit-content" }}
                  >
                    <p className={styles.title}>{t("terrain")}</p>
                    <div className={styles.inputRow}>
                      <InputBase
                        className={styles.input}
                        placeholder={t("from")}
                        type="number"
                        value={filters?.terrain?.[0] ?? undefined}
                        onChange={(d) => {
                          const value = [...(filters.terrain ?? [])];
                          value[0] = Number(d.target.value);

                          setFilters({ ...filters, terrain: value });
                        }}
                      />
                      <InputBase
                        className={styles.input}
                        placeholder={t("until")}
                        type="number"
                        value={filters?.terrain?.[1] ?? undefined}
                        onChange={(d) => {
                          const value = [...(filters.terrain ?? [])];
                          value[1] = Number(d.target.value);

                          setFilters({ ...filters, terrain: value });
                        }}
                      />
                    </div>
                  </div>
                </div>
                <div className={styles.cardLimit}>
                  <div
                    className={styles.card}
                    style={{ height: "fit-content" }}
                  >
                    <p className={styles.title}>{t("built")}</p>
                    <div className={styles.inputRow}>
                      <InputBase
                        className={styles.input}
                        placeholder={t("from")}
                        type="number"
                        value={filters?.built?.[0] ?? undefined}
                        onChange={(d) => {
                          const value = [...(filters.built ?? [])];
                          value[0] = Number(d.target.value);

                          setFilters({ ...filters, built: value });
                        }}
                      />
                      <InputBase
                        className={styles.input}
                        placeholder={t("until")}
                        type="number"
                        value={filters?.built?.[1] ?? undefined}
                        onChange={(d) => {
                          const value = [...(filters.built ?? [])];
                          value[1] = Number(d.target.value);

                          setFilters({ ...filters, built: value });
                        }}
                      />
                    </div>
                  </div>
                </div>
              </div>
              <div className={styles.card}>
                <p className={styles.title}>{t("urbType")}</p>
                {urbTypes.map((d) => {
                  return (
                    <Button
                      variant="contained"
                      key={d.value}
                      disableElevation
                      className={styles.button}
                      style={{
                        minWidth: "22.5%",
                        background: filters.urbType?.includes(d.value)
                          ? PRIMARY_COLOR
                          : WHITE,
                        color: !filters.urbType?.includes(d.value)
                          ? PRIMARY_COLOR
                          : WHITE,
                      }}
                      onClick={() => handlePropertyUrbTypes(d.value)}
                    >
                      {d.label}
                    </Button>
                  );
                })}
              </div>
              <div className={styles.divisor}></div>
              <div className={styles.buttons} style={{ paddingTop: "20px" }}>
                <Button
                  variant="contained"
                  disableElevation
                  className={styles.buttonStyle}
                  onClick={handleClean}
                >
                  {t("clean")}
                </Button>
                <Button
                  variant="contained"
                  disableElevation
                  className={styles.buttonStyle}
                  style={{ borderColor: PRIMARY_COLOR, color: PRIMARY_COLOR }}
                  onClick={handleSubmit}
                >
                  {t("viewResults")}
                </Button>
              </div>
            </div>
          </Fade>
        )}
      </Popper>
    </>
  );
};

export default SearchComponent;
