/* eslint-disable react-hooks/exhaustive-deps */
import React, { useState, useEffect, useMemo, useCallback } from "react";
import styles from "./styles.module.scss";
import Image from "next/image";
import bg from "@/assets/bg/bg.svg";
import SearchComponent from "./components/SearchComponent/SearchComponent";
import { CircularProgress, Pagination, useMediaQuery } from "@mui/material";
import { useTranslations } from "next-intl";
import ReactCarousel from "@/components/ReactCarousel/ReactCarousel";
import PropertyCard from "@/components/PropertyCard/PropertyCard";
import banner from "@/assets/bg/banner.png";
import bannerResp from "@/assets/bg/bannerResp.png";
import { KeyboardArrowRight } from "@mui/icons-material";
import Link from "next/link";
import { PRIMARY_COLOR } from "@/styles/constants";
import useProperties from "@/hooks/useProperties/useProperties";
import { calculateTotalPages } from "@/lib/utils/paginationUtils";
import { getSeoIndex } from "@/lib/services/redux/reducers/properties/propertiesActions";
import {
  getSeoIndexParams,
  getSeoIndexResponse,
  SeoProperties,
} from "@/lib/services/redux/reducers/properties/propertiesActions.d";
import useRequestHandler from "@/hooks/useRequestHandler/useRequestHandler";
import { toQueryString } from "@/lib/utils/toQueryString";
import { useRouter } from "next/navigation";
import { AllRoutes } from "@/lib/routes";

const Home = () => {
  const t = useTranslations();

  const { fetcher: getSeoIndexFetch } = useRequestHandler<
    getSeoIndexResponse,
    getSeoIndexParams
  >(getSeoIndex);

  const navigation = useRouter();

  const {
    refetchPropertiesFeatured,
    refetchPropertiesSuperFeatured,
    fetchProperties,
    propertiesFeatured,
    propertiesSuperFeatured,
    loadingProperties,
    properties,
    totalProperties,
  } = useProperties();

  const [tabIndex, setTabIndex] = useState(0);
  const [page, setPage] = useState(0);
  const [seos, setSeos] = useState<getSeoIndexResponse>();

  const is933 = useMediaQuery("(max-width: 933px)");
  const is693 = useMediaQuery("(max-width: 693px)");
  const is571 = useMediaQuery("(max-width: 571px)");

  const cardsMinWidth = useMemo(() => {
    if (is693 && !is571) {
      return "47.5%";
    }
    if (is571) {
      return "100%";
    }

    return "304px";
  }, [is693]);

  const tabs = [
    {
      name: t("mainCities"),
      variation: "cities",
    },
    {
      name: "Estado de Mexico",
      variation: "cdmx",
    },
    {
      name: t("mainStates"),
      variation: "states",
    },
    {
      name: "Ciudad de Mexico",
      variation: "cdmx",
    },
    {
      name: t("mainLocations"),
      variation: "location",
    },
  ];

  const retryFunction = async (variation: getSeoIndexParams["variation"]) => {
    const query = await getSeoIndexFetch({
      variation,
      limit: 10,
    });

    if (query.status === "success") {
      setSeos(query.response);
    }
  };

  useEffect(() => {
    refetchPropertiesSuperFeatured();
    retryFunction("cities");
  }, []);

  useEffect(() => {
    fetchProperties(
      page * 12,
      12,
      "",
      0,
      0,
      0,
      0,
      1000000000,
      0,
      1000000000,
      1000000000,
      0,
      "",
      "",
      "",
      "vertical"
    );
  }, [page]);

  useEffect(() => {
    refetchPropertiesFeatured();

    const interval = setInterval(() => {
      refetchPropertiesFeatured();
    }, 120000);

    return () => clearInterval(interval);
  }, []);

  const handleClickLinkOnTab = useCallback(
    (
      category: string,
      locationid: string,
      type_id: string,
      origin: SeoProperties["origin"],
      prompt?: string
    ) => {
      const stringParams = toQueryString({
        [origin === "city"
          ? "city_id"
          : origin === "state"
          ? "state_id"
          : "colony_id"]: locationid,
        propertyType: type_id,
        category,
        search: prompt,
        ignore_search: true,
      });

      navigation.push(AllRoutes.RESULTS_VIEW + stringParams);
    },
    [navigation]
  );

  return (
    <div className={styles.container}>
      <div className={styles.welcomeView}>
        <SearchComponent />
        <Image className={styles.welcomeViewBg} src={bg} alt={"bg-fieloo"} />
      </div>
      {/**
       * <div className={styles.bannerView}>
        <div className={styles.banner}>
          <Image
            className={styles.bannerHome}
            src={is933 ? bannerResp : banner}
            alt="banner2"
          />
        </div>
      </div>
       */}
      <div className={styles.properties} style={{ marginTop: "100px" }}>
        <p className={styles.title}>{t("superFeatured")}</p>
        <ReactCarousel
          data={propertiesSuperFeatured}
          componentToRender={PropertyCard}
          skeletonComponentToRender={PropertyCard}
        />
      </div>
      {/**
       * <div className={styles.bannerView}>
        <div className={styles.banner}>
          <Image
            className={styles.bannerHome}
            src={is933 ? bannerResp : banner}
            alt="banner2"
          />
        </div>
      </div>
       */}
      <div className={styles.properties}>
        <p className={styles.title}>{t("featured")}</p>

        <div className={styles.propertiesRowWrap}>
          {propertiesFeatured.map((d) => {
            return (
              <PropertyCard
                fulldata={d}
                key={d.id}
                type={"simple"}
                title={d.titulo}
                totalBeds={d?.habitaciones ?? 0}
                totalBaths={d?.baños ?? 0}
                totalHomes={d?.pisos ?? 1}
                totalParkings={d?.parking ?? 0}
                price={d.precio}
                categoy={
                  d.categories
                    ? d.categories.nombre === "Venta"
                      ? "sale"
                      : "rent"
                    : "rent"
                }
                description={d.descripcion}
                img={d.imgs && d.imgs.length > 0 ? d.imgs[0] : null}
                userImg={d.users?.img ?? null}
                userTotalProperties={d.users?.totalProperties ?? 0}
                userId={d.users?.id ?? ""}
                slug={d.slug}
                user={d.users}
                minWidth={cardsMinWidth}
              />
            );
          })}
        </div>
      </div>
      <div className={styles.bannerView}>
        <div className={styles.banner}>
          <Image
            className={styles.bannerHome}
            src={is933 ? bannerResp : banner}
            alt="banner2"
          />
        </div>
      </div>
      <div className={styles.properties} style={{ marginBottom: 100 }}>
        <p className={styles.title}>{t("properties")}</p>
        <div className={styles.propertiesRowWrap}>
          {loadingProperties && (
            <div className={styles.loading}>
              <CircularProgress color="primary" />
            </div>
          )}
          {properties.map((d) => {
            return (
              <PropertyCard
                fulldata={d}
                key={d.id}
                type={
                  d.isSuperFeatured
                    ? "super"
                    : d.isFeatured
                    ? "simple"
                    : "original"
                }
                title={d.titulo}
                totalBeds={d?.habitaciones ?? 0}
                totalBaths={d?.baños ?? 0}
                totalHomes={d?.pisos ?? 1}
                totalParkings={d?.parking ?? 0}
                price={d.precio}
                categoy={
                  d.categories
                    ? d.categories.nombre === "Venta"
                      ? "sale"
                      : "rent"
                    : "rent"
                }
                description={d.descripcion}
                img={d.imgs && d.imgs.length > 0 ? d.imgs[0] : null}
                userImg={d.users?.img ?? null}
                userTotalProperties={d.users?.totalProperties ?? 0}
                userId={d.users?.id ?? ""}
                slug={d.slug}
                user={d.users}
                minWidth={cardsMinWidth}
              />
            );
          })}
        </div>
        <div className={styles.paginationContainer}>
          {calculateTotalPages(totalProperties ?? 0, 12) > 0 && (
            <Pagination
              count={calculateTotalPages(totalProperties ?? 0, 12)}
              color="primary"
              page={page}
              onChange={(_, page) => {
                if (setPage) setPage(page);
              }}
            />
          )}
        </div>
      </div>
      <div className={styles.featuredContainer} style={{ marginBottom: 100 }}>
        <p className={styles.title}>{t("featured")}</p>
        <div className={styles.tabsContainer}>
          <div className={styles.tabs}>
            {tabs.map((d, i) => {
              return (
                <div
                  onClick={() => {
                    setTabIndex(i);
                    retryFunction(
                      d?.variation as getSeoIndexParams["variation"]
                    );
                  }}
                  className={[
                    styles.tab,
                    tabIndex === i ? styles.tab_selected : "",
                  ].join(" ")}
                  key={d.name + i}
                >
                  <p>{d.name}</p>
                </div>
              );
            })}
          </div>
        </div>
        <div className={styles.subitems}>
          <div className={styles.cols}>
            <p className={styles.title}>{t("selling")}</p>
            {(seos?.properties_by_sale ?? []).map((d, i) => {
              return (
                <div className={styles.stateItem} key={i}>
                  <p className={styles.subtitle}>{d.name}</p>
                  <p
                    className={styles.subItem}
                    onClick={() =>
                      handleClickLinkOnTab(
                        d.category,
                        d.id,
                        d.types.house?.id,
                        d.origin,
                        d.types.house?.name +
                          `, ${t("in")} ${t("sale")} ` +
                          d.name
                      )
                    }
                  >
                    <KeyboardArrowRight color="primary" /> Casas
                  </p>
                  <p
                    className={styles.subItem}
                    onClick={() =>
                      handleClickLinkOnTab(
                        d.category,
                        d.id,
                        d.types.department.id,
                        d.origin,
                        d.types.department.name +
                          `, ${t("in")} ${t("sale")} ` +
                          d.name
                      )
                    }
                  >
                    <KeyboardArrowRight color="primary" /> Departamentos
                  </p>
                </div>
              );
            })}
          </div>
          <div className={styles.cols}>
            <p className={styles.title}>{t("rents")}</p>
            {(seos?.properties_by_rent ?? []).map((d, i) => {
              return (
                <div className={styles.stateItem} key={i}>
                  <p className={styles.subtitle}>{d.name}</p>
                  <p
                    className={styles.subItem}
                    onClick={() =>
                      handleClickLinkOnTab(
                        d.category,
                        d.id,
                        d.types.house?.id,
                        d.origin,
                        d.types.house?.name +
                          `, ${t("in")} ${t("rent")} ` +
                          d.name
                      )
                    }
                  >
                    <KeyboardArrowRight color="primary" /> Casas
                  </p>
                  <p
                    className={styles.subItem}
                    onClick={() =>
                      handleClickLinkOnTab(
                        d.category,
                        d.id,
                        d.types.department.id,
                        d.origin,
                        d.types.department.name +
                          `, ${t("in")} ${t("rent")} ` +
                          d.name
                      )
                    }
                  >
                    <KeyboardArrowRight color="primary" /> Departamentos
                  </p>
                </div>
              );
            })}
          </div>
        </div>
      </div>
      <div className={styles.otherLinks} style={{ marginBottom: 100 }}>
        <div className={styles.stateItem}>
          <p className={styles.subtitle}>{t("popularSearches")}</p>
          <p className={styles.subItem}>
            <KeyboardArrowRight color="primary" /> Casas
          </p>
          <p className={styles.subItem}>
            <KeyboardArrowRight color="primary" /> Departamentos
          </p>
          <p className={styles.subItem}>
            <KeyboardArrowRight color="primary" /> Casas
          </p>
          <p className={styles.subItem}>
            <KeyboardArrowRight color="primary" /> Departamentos
          </p>
          <Link
            style={{ color: PRIMARY_COLOR }}
            className={styles.subItem}
            href={"/"}
          >
            {" "}
            <KeyboardArrowRight sx={{ color: "#fff" }} />
            {t("viewMore")}
          </Link>
        </div>
        <div className={styles.stateItem}>
          <p className={styles.subtitle}>{t("tooSearched")}</p>
          <p className={styles.subItem}>
            <KeyboardArrowRight color="primary" /> Casas
          </p>
          <p className={styles.subItem}>
            <KeyboardArrowRight color="primary" /> Departamentos
          </p>
          <p className={styles.subItem}>
            <KeyboardArrowRight color="primary" /> Casas
          </p>
          <p className={styles.subItem}>
            <KeyboardArrowRight color="primary" /> Departamentos
          </p>
          <Link
            style={{ color: PRIMARY_COLOR }}
            className={styles.subItem}
            href={"/"}
          >
            {" "}
            <KeyboardArrowRight sx={{ color: "#fff" }} />
            {t("viewMore")}
          </Link>
        </div>
        <div className={styles.stateItem}>
          <p className={styles.subtitle}>{t("frecuentRequests")}</p>
          <p className={styles.subItem}>
            <KeyboardArrowRight color="primary" /> Casas
          </p>
          <p className={styles.subItem}>
            <KeyboardArrowRight color="primary" /> Departamentos
          </p>
          <p className={styles.subItem}>
            <KeyboardArrowRight color="primary" /> Casas
          </p>
          <p className={styles.subItem}>
            <KeyboardArrowRight color="primary" /> Departamentos
          </p>
          <Link
            style={{ color: PRIMARY_COLOR }}
            className={styles.subItem}
            href={"/"}
          >
            {" "}
            <KeyboardArrowRight sx={{ color: "#fff" }} />
            {t("viewMore")}
          </Link>
        </div>
      </div>
    </div>
  );
};

export default Home;
