/* eslint-disable react-hooks/exhaustive-deps */
import React, { useCallback, useEffect, useMemo, useState } from "react";
import styles from "./styles.module.scss";
// import { useTranslations } from "next-intl";
import MyPropertiesHeader from "./components/MyPropertiesHeader/MyPropertiesHeader";
import noProperties from "@/assets/bg/noProperties.svg";
import Image from "next/image";
import { SearchObject } from "../Results/components/MoreFilters/moreFilters";
import { getPropertiesUser } from "@/lib/services/redux/reducers/properties/propertiesActions";
import useRequestHandler from "@/hooks/useRequestHandler/useRequestHandler";
import {
  GetPropertiesParams,
  GetPropertiesResponse,
  IPropertyFeatured,
} from "@/lib/services/redux/reducers/properties/propertiesActions.d";
import { calculateTotalPages } from "@/lib/utils/paginationUtils";
import { CircularProgress, MenuItem, Pagination, Select } from "@mui/material";
import PropertyCard from "@/components/PropertyCard/PropertyCard";
import { useMediaQuery } from "@mui/system";

const MyProperties = () => {
  // const t = useTranslations();

  const [totalHere, setTotalHere] = useState<number>(0);

  const [filters, setFilters] = useState<SearchObject>({
    offset: 0,
    limit: 12,
  });

  const is693 = useMediaQuery("(max-width: 693px)");
  const is571 = useMediaQuery("(max-width: 571px)");

  const cardsMinWidth = useMemo(() => {
    if (is693 && !is571) {
      return "47.5%";
    }
    if (is571) {
      return "100%";
    }

    return "304px";
  }, [is693]);

  const { fetcher: getPropertiesFetch, requestStatus: propertiesStatus } =
    useRequestHandler<GetPropertiesResponse, GetPropertiesParams>(
      getPropertiesUser
    );

  const [properties, setProperties] = useState<IPropertyFeatured[]>([]);

  const retryFunction = useCallback(
    async (currentFilters?: Partial<SearchObject>) => {
      const payload = {
        offset: currentFilters?.offset ?? filters?.offset ?? 0,
        limit: currentFilters?.limit ?? filters?.limit ?? 10,
      };

      const query = await getPropertiesFetch(payload);

      if (query.status === "success") {
        setProperties(query.response.properties);
        setTotalHere(query.response.total ?? 0);
      }
    },
    [filters, setProperties, setTotalHere]
  );

  useEffect(() => {
    retryFunction();
  }, []);

  return (
    <div className={styles.container}>
      <div className={styles.properties}>
        <MyPropertiesHeader retryFunction={retryFunction} />
        <div className={styles.propertiesRowWrap}>
          {properties.length === 0 && !propertiesStatus.loading && (
            <div className={styles.noData}>
              <Image src={noProperties} alt="noProperties" />
            </div>
          )}
          {propertiesStatus.loading && (
            <div className={styles.noData}>
              <CircularProgress size={"50px"} color="primary" />
            </div>
          )}
          {!propertiesStatus?.loading && (
            <>
              {properties.map((d) => {
                return (
                  <PropertyCard
                    key={d.id}
                    fulldata={d}
                    type={
                      d.isSuperFeatured
                        ? "super"
                        : d.isFeatured
                        ? "simple"
                        : "original"
                    }
                    title={d.titulo}
                    totalBeds={d?.habitaciones ?? 0}
                    totalBaths={d?.baños ?? 0}
                    totalHomes={Number(d?.pisos) ?? 1}
                    totalParkings={d?.parking ?? 0}
                    price={d.precio}
                    categoy={
                      d.categories
                        ? d.categories.nombre === "Venta"
                          ? "sale"
                          : "rent"
                        : "rent"
                    }
                    description={d.descripcion}
                    img={d.imgs && d.imgs.length > 0 ? d.imgs[0] : null}
                    userImg={d.users?.img ?? null}
                    userTotalProperties={d.users?.totalProperties ?? 0}
                    userId={d.users?.id ?? ""}
                    slug={d.slug}
                    user={d.users}
                    minWidth={cardsMinWidth}
                  />
                );
              })}
            </>
          )}
        </div>
        {calculateTotalPages(totalHere ?? 0, 12) > 0 && (
          <div className={styles.paginationContainer}>
            <Pagination
              count={calculateTotalPages(totalHere ?? 0, 12)}
              color="primary"
              page={(filters?.offset ?? 0) + 1}
              onChange={(_, page) => {
                if (setFilters) {
                  const payload = {
                    ...filters,
                    offset: page - 1,
                  };
                  setFilters(payload);
                  retryFunction(payload);
                }
              }}
            />
            <Select
              value={filters?.limit}
              size="small"
              onChange={(event) => {
                if (setFilters) {
                  const payload = {
                    ...filters,
                    limit: event.target.value - 1,
                  };
                  setFilters(payload);
                  retryFunction(payload);
                }
              }}
            >
              {[12, 24, 32, 64, 128, 256, 512, 1024].map((p) => {
                return (
                  <MenuItem key={p} value={p}>
                    {p}
                  </MenuItem>
                );
              })}
            </Select>
          </div>
        )}
      </div>
    </div>
  );
};

export default MyProperties;
