/* eslint-disable @typescript-eslint/no-explicit-any */
import React, { useState } from "react";
import styles from "./styles.module.scss";
import { useTranslations } from "next-intl";
import { Button } from "@mui/material";
import { Add, ContentPasteGo } from "@mui/icons-material";
import { AllRoutes } from "@/lib/routes";
import { useRouter } from "next/navigation";
import ImportModal from "@/components/ImportModal/ImportModal";

interface MyPropertiesHeaderProps {
  retryFunction: () => any;
}

const MyPropertiesHeader: React.FC<MyPropertiesHeaderProps> = ({
  retryFunction,
}) => {
  const t = useTranslations();
  const navigate = useRouter();

  const [openModal, setOpenModal] = useState<boolean>(false);

  const handleCreateProperty = () => {
    navigate.push(AllRoutes.CREATE_PROPERTY);
  };

  return (
    <div className={styles.container}>
      <p className={styles.title}>{t("myProperties")}</p>
      <div className={styles.divider}></div>
      <div className={styles.filters}>
        <Button
          variant="contained"
          disableElevation
          className={styles.addProperty}
          onClick={handleCreateProperty}
          startIcon={<Add htmlColor={"#13A407"} />}
        >
          {t("addProperty")}
        </Button>
        <Button
          variant="contained"
          disableElevation
          className={styles.import}
          onClick={() => setOpenModal(!openModal)}
          startIcon={<ContentPasteGo htmlColor={"#E23052"} />}
        >
          {t("import")}
        </Button>
        {/* <div className={styles.filter}>
          <FormInput
            required={false}
            variationConfig={{
              type: "selector",
              fullWidth: true,
              inputProps: {
                options: [
                  "recents",
                  "a-z",
                  "owners",
                  "locations",
                  "shared",
                ].map((item) => ({
                  label: t(item),
                  name: item,
                  value: item,
                })),
                selectedItem: "" as string,
                placeholder: t("orderBy"),
                onClickItem: (val) => {
                  console.log(val);
                },
              },
            }}
          />
        </div> */}
        <ImportModal
          modalProps={{ isOpen: openModal, toggle: () => setOpenModal(false) }}
          retryFunction={retryFunction}
        />
      </div>
    </div>
  );
};

export default MyPropertiesHeader;
