/* eslint-disable @typescript-eslint/no-explicit-any */
import { FormikProps } from "formik";
import { registerFormData } from "../types";
import { FormInputVariations } from "@/components/FormInput/types";
import { PRIMARY_COLOR } from "@/styles/constants";

export const initialStateRegisterForm = (): registerFormData => {
  return {
    name: "",
    last_name: "",
    email: "",
    password: "",
    passwordRepeat: "",
    terms: 0,
  };
};

export const requiredFieldsRegisterForm: Record<
  keyof registerFormData,
  boolean
> = {
  name: true,
  last_name: true,
  email: true,
  password: true,
  passwordRepeat: true,
  terms: true,
};

export const keysRegisterForm = [
  "header1",
  "divider",
  "name",
  "last_name",
  "email",
  "header2",
  "password",
  "passwordRepeat",
  "terms",
  "submit",
];

export const RegisterFormInputs =
  (loading?: boolean) =>
  (
    key: keyof registerFormData,
    formikMetadata: FormikProps<registerFormData>,
    t: any
  ): Record<keyof registerFormData | string, FormInputVariations> => {
    const { values, setValues, handleChange, submitForm } = formikMetadata;

    const inputs: Record<keyof registerFormData | string, FormInputVariations> =
      {
        header1: {
          type: "title_and_subtitle",
          texts: {
            title: t("basicInfo"),
            showBottomDivider: true,
            titleStyle: {
              textAlign: "left",
              fontWeight: 700,
              fontSize: 20,
            },
          },
        },
        name: {
          type: "text",
          inputProps: {
            value: values[key] as string,
            placeholder: t(key),
            onChange: handleChange(key),
          },
        },
        last_name: {
          type: "text",
          inputProps: {
            value: values[key] as string,
            placeholder: t(key),
            onChange: handleChange(key),
          },
        },
        email: {
          type: "text",
          inputProps: {
            value: values[key] as string,
            placeholder: t(key),
            onChange: handleChange(key),
          },
        },
        header2: {
          type: "title_and_subtitle",
          texts: {
            title: t("createPassword"),
            showBottomDivider: true,
            titleStyle: {
              textAlign: "left",
              fontWeight: 700,
              fontSize: 20,
            },
          },
        },
        password: {
          type: "text",
          inputProps: {
            value: values[key] as string,
            placeholder: t(key),
            passwordMode: true,
            onChange: handleChange(key),
          },
        },
        passwordRepeat: {
          type: "text",
          inputProps: {
            value: values[key] as string,
            placeholder: t(key),
            passwordMode: true,
            onChange: handleChange(key),
          },
        },
        terms: {
          type: "radios-group",
          fullWidth: true,
          hideLabel: true,
          radios: [
            {
              value: "termsAndConditions",
              label: t("termsAndConditionsText"),
              checked: Boolean(values[key]),
              onClick: () => setValues({ ...values, [key]: true }),
            },
          ],
        },
        submit: {
          type: "button",
          button: {
            onClick: submitForm,
            children: t("register"),
            variant: "contained",
            color: "primary",
            disableElevation: true,
            style: {
              width: "254px",
              height: "50px",
              backgroundColor: PRIMARY_COLOR,
              borderRadius: "100px",
              display: "flex",
              justifyContent: "center",
              alignItems: "center",
              color: "#fff",
            },
            loading: loading,
            disabled: loading || !values.terms,
          },
        },
      };

    return inputs;
  };
