import React, { useRef, useState } from "react";
import styles from "./styles.module.scss";
import { useTranslations } from "next-intl";
import FormMaker from "@/components/FormMaker/FormMaker";
import { registerFormData } from "./types";
import {
  initialStateRegisterForm,
  keysRegisterForm,
  requiredFieldsRegisterForm,
  RegisterFormInputs,
} from "./forms/formInputs";
import { FormikProps } from "formik";
import useRequestHandler from "@/hooks/useRequestHandler/useRequestHandler";
import { registerUser } from "@/lib/services/redux/reducers/user/userActions";
import {
  RegisterUserParams,
  RegisterUserResponse,
} from "@/lib/services/redux/reducers/user/userActions.d";
import useRnSwal from "@/hooks/useRnSwal/useRnSwal";
import { AllRoutes } from "@/lib/routes";
import { useRouter } from "next/navigation";
import SwalComponent from "@/components/SwalComponent/SwalComponent";

const Register = () => {
  const t = useTranslations();
  const formikRef = useRef<FormikProps<registerFormData>>(null);

  const navigate = useRouter();

  const [FormErrors] = useState<(keyof registerFormData)[]>([]);

  const { fetcher, requestStatus } = useRequestHandler<
    RegisterUserResponse,
    RegisterUserParams
  >(registerUser);

  const { clearAll, showAlert } = useRnSwal();

  const handleSubmit = async (values: registerFormData) => {
    const payload: Omit<RegisterUserParams, "context"> = {
      name: values?.name,
      email: values?.email,
      password: values?.password,
      lastName: values?.last_name,
      confirmPassword: values?.passwordRepeat,
      termsAndConditions: values?.terms,
    };

    const query = await fetcher(payload);
    if (query.status === "success") {
      showAlert(
        "success",
        t("registerSuccess"),
        undefined,
        undefined,
        undefined,
        () => {
          clearAll();
          navigate.push(AllRoutes.MAIN);
        }
      );
    }
  };

  return (
    <div className={styles.container}>
      <div className={styles.maxContainer} style={{ marginBottom: 100 }}>
        <p className={styles.pageTitle}>{t("register")}</p>
        <div className={styles.divider}></div>
        <div className={styles.formContainer}>
          <FormMaker<registerFormData>
            keys={keysRegisterForm}
            innerRef={formikRef}
            initialState={initialStateRegisterForm()}
            requiredFields={requiredFieldsRegisterForm}
            handleSubmit={handleSubmit}
            errorLabels={FormErrors}
            formSteps={RegisterFormInputs(requestStatus.loading)}
          />
          <SwalComponent />
        </div>
      </div>
    </div>
  );
};

export default Register;
