/* eslint-disable react-hooks/exhaustive-deps */
import React, { useEffect, useRef, useState } from "react";
import styles from "./styles.module.scss";
import { useTranslations } from "next-intl";
import FormMaker from "@/components/FormMaker/FormMaker";
import useAuthentication from "@/hooks/useAuthentication/useAuthentication";
import { updateProfileFormData } from "./types.d";
import {
  initialStateUpdateProfileForm,
  keysUpdateProfileForm,
  requiredFieldsUpdateProfileForm,
  UpdateProfileFormInputs,
} from "./forms/formInputs";
import { FormikProps } from "formik";
import { SelectOptionsProps } from "@/components/FormInput/types";
import useCountries from "@/hooks/useCountries/useCountries";
import useRequestHandler from "@/hooks/useRequestHandler/useRequestHandler";
import { updateUser } from "@/lib/services/redux/reducers/user/userActions";
import {
  UpdateUserParams,
  UpdateUserResponse,
} from "@/lib/services/redux/reducers/user/userActions.d";
import { recoveryTokenResponse } from "@/lib/services/redux/reducers/user/userActions.d";
import { recoveryTokenParams } from "@/lib/services/redux/reducers/user/userActions.d";
import { recoveryToken } from "@/lib/services/redux/reducers/user/userActions";

const UpdateProfile = () => {
  const t = useTranslations();
  const formikRef = useRef<FormikProps<updateProfileFormData>>(null);

  const { user } = useAuthentication();

  const [states, setStates] = useState<SelectOptionsProps[]>([]);
  const [cities, setCities] = useState<SelectOptionsProps[]>([]);

  const { fetcher, requestStatus } = useRequestHandler<
    UpdateUserResponse,
    UpdateUserParams
  >(updateUser);

  const [FormErrors] = useState<(keyof updateProfileFormData)[]>([]);

  const { fetcher: recoveryTokenFetch } = useRequestHandler<
    recoveryTokenResponse,
    recoveryTokenParams
  >(recoveryToken);

  const {
    countries,
    phoneCodes,
    fetchStates,
    fetchCities,
    refetchCountries,
    refetchCountryPhoneCodes,
  } = useCountries();

  const handleSubmit = async (values: updateProfileFormData) => {
    const ladaPhone = phoneCodes.find(
      (item) => item.value === (values.phone?.select ?? "")
    );
    const officePhone = phoneCodes.find(
      (item) => item.value === (values.officePhone?.select ?? "")
    );
    const gender = values?.gender ?? "";
    let sex = "I";

    if (gender) {
      sex = gender === "M" ? "H" : gender === "F" ? "M" : "I";
    }

    const payload: Omit<UpdateUserParams, "context"> = {
      state: values.state ?? "",
      name: values.name ?? "",
      phone: (ladaPhone?.code ?? "52") + (values.phone?.input ?? ""),
      officePhone:
        (officePhone?.code ?? "52") + (values.officePhone?.input ?? ""),
      country: values.country ?? "",
      city: values.city ?? "",
      tiktok: values.tiktok ?? "",
      instagram: values.instagram ?? "",
      youtube: values.youtube ?? "",
      linkedin: values.linkedin ?? "",
      lastName: values.last_name ?? "",
      sex: sex,
      profileCompany: values.companyProfile ?? "",
      showModalPassword: values.restorePassword ?? 0,
      password: values.password ?? "",
      confirmPassword: values.confirmPassword ?? "",
      companyName: values.propertyName ?? "",
      companyLat: values?.location.lat ?? 0,
      companyLng: values?.location.lng ?? 0,
      companyLocation: values.address ?? "",
      twitter: values.x ?? "",
      facebookpage: values.facebook ?? "",
    };

    const response = await fetcher(payload);

    if (response.status === "success") {
      recoveryTokenFetch({});
    }
  };

  const handleStates = (country: string, noClean?: boolean) => {
    setCities([]);
    if (country) {
      fetchStates(country).then((result) => {
        setStates(result);
        if (!noClean) {
          formikRef.current?.setValues({
            ...formikRef.current.values,
            city: "",
          });
        }
      });
    }
  };
  const handleCities = (country: string, state: string) => {
    if (country && state) {
      fetchCities(country, state).then((result) => {
        setCities(result);
      });
    }
  };

  useEffect(() => {
    refetchCountries();
    refetchCountryPhoneCodes();

    if (user?.country) {
      handleStates(user?.country, true);

      if (user?.state) {
        handleCities(user?.country, user?.state);
      }
    }
  }, [user]);

  useEffect(() => {
    const mexico = countries.find((d) => d.label === "Mexico");
    if (formikRef.current && mexico) {
      formikRef.current.setValues({
        ...formikRef?.current?.values,
        country: mexico?.value,
        locationCenter: {
          lat: mexico.lat,
          lng: mexico.lng,
        },
      });
      handleStates(mexico?.value);
    }
  }, [countries, formikRef]);

  return (
    <div className={styles.container}>
      <div className={styles.maxContainer} style={{ marginBottom: 100 }}>
        <p className={styles.pageTitle}>{t("updateProfile")}</p>
        <div className={styles.divider}></div>
        <div className={styles.formContainer}>
          <FormMaker<updateProfileFormData>
            keys={keysUpdateProfileForm}
            innerRef={formikRef}
            initialState={initialStateUpdateProfileForm(user)}
            requiredFields={requiredFieldsUpdateProfileForm}
            handleSubmit={handleSubmit}
            errorLabels={FormErrors}
            formSteps={UpdateProfileFormInputs(
              phoneCodes,
              countries ?? [],
              states ?? [],
              cities ?? [],
              handleStates,
              handleCities,
              user,
              requestStatus.loading
            )}
          />
        </div>
      </div>
    </div>
  );
};

export default UpdateProfile;
