import { createTheme } from "@mui/material/styles";
import {
  PRIMARY_COLOR,
  PRIMARY_COLOR_DARKER,
  SECONDARY_COLOR,
} from "./constants";

const theme = createTheme({
  palette: {
    primary: {
      main: PRIMARY_COLOR,
      dark: PRIMARY_COLOR_DARKER,
    },
    secondary: {
      main: SECONDARY_COLOR,
      dark: SECONDARY_COLOR,
    },
    error: {
      main: "#FF4D4F",
      light: "#FF9495",
    },
    warning: {
      main: "#F9F136",
      light: "#FBF686",
    },
    success: {
      main: "#52C41A",
      light: "#97DB75",
    },
    info: {
      main: "#FFFFFF",
      light: "#B8B8B8",
    },
  },
  typography: {
    fontFamily: "Raleway, sans-serif",
  },
  breakpoints: {
    values: {
      xs: 361,
      sm: 601,
      md: 769,
      lg: 900,
      xl: 1201,
    },
  },
});

export default theme;
