/* eslint-disable @typescript-eslint/no-explicit-any */
import BackendFetching from "@/lib/services/context/class";
import { BottomTabNavigationOptions } from "@react-navigation/bottom-tabs";

export interface FileData {
  name: string;
  type: string;
  uri: string;
}

export interface ReduxToolkitThunkWithContext {
  context: InstanceType<typeof BackendFetching>;
}

export interface BasicModelStructure {
  id: string;
}

export interface LaravelSuccessResponseObject {
  error: false;
  data: any;
}

export interface LaravelErrorResponseObject {
  error: true;
  message: string;
}

export type LaravelResponseObject =
  | LaravelSuccessResponseObject
  | LaravelErrorResponseObject;

export type LaravelResponseObjectPromise = Promise<LaravelResponseObject>;

export interface LaravelMainModelProps {
  id: number;
  hash: string;
  mod_by: string;
  created_at: Date;
  updated_at: Date;
}

export interface ScreenDeclaration {
  options: BottomTabNavigationOptions | StackNavigation;
  name: string;
  component: React.FC<any>;
  dashboard?: React.FC<any>;
  hideOnAuth?: boolean;
}
