import { Roles } from "../../constants/permissions";
import { LaravelMainModelProps } from "../main/types";

export interface Role {
  id?: number;
  name: string;
  label: Roles;
  hash: string;
  modby: number;
  createdby: number;
  created_at: string;
  updated_at: string;
  pivot: {
    user_id: number;
    role_id: number;
    location_id: number;
    modby: number;
  };
}

export interface UserInterface extends LaravelMainModelProps {
  apellido: string;
  correo: string;
  id: string;
  img: string;
  lat: number;
  lng: number;
  nombre: string;
  ownerId: string;
  role: string;
  sex: string;
  country: string;
  state: string;
  city: string;
  direccionFisica: string;
  nombreInmobiliaria: string;
  facebookpage: string;
  instagram: string;
  linkedin: string;
  sitioweb: string;
  twitter: string;
  youtube: string;
  tiktok: string;
  totalFollowme: number;
  totalProperties: number;
  telefonoOficina: string;
  telefonoPersonal: string;
  perfilEmpresarial: string;
  recibirCorreo?: boolean;
  countries?: {
    id: string;
    name: string;
    latitude?: number;
    longitude?: number;
  } | null;
  states?: {
    id: string;
    name: string;
    latitude?: number;
    longitude?: number;
  } | null;
  cities?: {
    id: string;
    name: string;
    latitude?: number;
    longitude?: number;
  } | null;
}
